#!/usr/bin/python3
# -*- coding: utf-8 -*-
"""
Das Programm liest eine CSV-Datei (oder auch txt-Datei) ein
entfernt die Kommas und macht aus jedem Eintrag zwischen Kommas eine eigene zelle

Zuunterst den Namen der Dateo (zuunterst!) abändern in den Namen der Datei, die bearbeitet werden soll.

Dieses Python-Programm und die zu bearbeitende Datei müssen sich im gleichen
Ordner befinden (z.B. auf dem Desktop).

Es kann ein Trigger verwendet werden, so dass das Zerlegen der Zeilen erst beginnt,
wenn dieser Trigger vorbei ist (im vorliegenden Beispiel "M/Z".
Diese Möglichkeit wird hier aber nicht verwendet.

@author: Urs Leisinger

https://sdbs.db.aist.go.jp/sdbs/cgi-bin/cre_search.cgi
"""

#Importieren des Moduls, das nötig ist, um csv-Dateien zu lesen und zu schreiben
import csv

import matplotlib.pyplot as plt
import re
import numpy as np
from matplotlib.ticker import (MultipleLocator, FormatStrFormatter,
                               AutoMinorLocator)

Freq = 25.15 #MHz

import matplotlib.patches as patches
import matplotlib.path as path

gs_kw = dict(wspace=0.3, left = 0.1, right =0.9, bottom = 0.2, top = 0.9)
fig,ax = plt.subplots(nrows = 1, ncols=1, sharey = False, figsize = (6,2), gridspec_kw =gs_kw, constrained_layout = True)



#dateien = ["co2.txt","CO_kohlenstoffmonoxid.txt","hydrogencarbonat.txt","carbonat.txt","H3CO3_plus.txt"]
import glob

dateien = ['dmso.txt','acac.txt','propylamin.txt']
dateien = ['butanal.txt', 'dimethoxyethan.txt', 'propylamin.txt']

dateien = ['propanal.txt']
dateien = ["propannitril.txt"]
dateien = ["ethen.txt"]
dateien = glob.glob('*.txt')
print(dateien)


verzeichnis = 'DatenUndSpektren'
verzeichnis = "."
dateien = glob.glob(verzeichnis+'/*.txt')
for i in range(len(dateien)):
    print(dateien[i])
    dateien[i]=dateien[i].split("\\")[1]


iVerschiebung = 0
iPeakhoehe = 1


def bearbeiten(datei,verzeichnis):
    """
    Solange werte=False ist man im Kopfbereich der Datei
    der noch keine Daten enthält (damit hier nicht auch alle Zeilen
    verdoppelt und Nullen hinzugefügt werden
    """
    #werte=False;
    werte=True;
    xrand = 8
    """
    Nun wird die neu zu speichernde Datei vorbereitet.
    Sie soll gleich heissen, wie die alte, aber mit dem Zusatz _neu
    Zu diesem Zweck wird der alte Dateiname zuerst beim Punkt in zwei Teile zerlegt (mit split)
    der erste Teil (also der Name ohne das Kürzel ".csv" wird mit _neu.csv
    zusammengebaut. Das ist dann der neue Dateiname)
    """
    dateipfad = verzeichnis+"/"+datei
    #ursprüngliche Datei einlesen
    print("Datei wird eingelesen")
    with open(dateipfad,'r') as dateiLesen: #open(datei,'rb')
        plt.cla()
        #um das bytes-Objekt in str-Objekt umzuwandeln
        dateiEingelesen=dateiLesen.read()#.decode("utf-8")
        print(dateiEingelesen)
        #hier wird die eingelesene Datei in einzelne Zeilen zerlegt (Zeilenwechsel: \n)
        #Wenn die eingelesene Datei ein bytes-Objekt ist, muss auch die zu splittende Stelle
        #als byte-objekt (also mit b vor den Anführungszeichen) übergeben werden.
        #dateiEingelesen=dateiEingelesen.split(b'\n')
        dateiEingelesen=dateiEingelesen.split('\n')
        verschiebung=[]
        hoehe=[]
        wertebereich=True
        for zeile in dateiEingelesen:
            if zeile !='' and zeile.find('#')==-1 and zeile.find('ppm')==-1:
                werteset=zeile.split()
                print("zeile",zeile)
                print("wertepaar", werteset)
                if wertebereich == True and  re.search(werteset[0], 'ö')!='none':
                    chemischeVerschichiebung = float(werteset[iVerschiebung])
                    peakhoehe = float(werteset[iPeakhoehe])
                    verschiebung.append(chemischeVerschichiebung)
                    hoehe.append(peakhoehe)
        #minima suchen                

        verschiebung = np.array(verschiebung) 
        hoehe = np.array(hoehe)
        print("verschiebung, höhe", verschiebung, hoehe)

        for iWerte in range(len(verschiebung)):
            
            #einfache Variante: Striche
            #plt.plot([masse[iWerte],masse[iWerte]],[0,hoeheProzent[iWerte]],'k-', lw=1.5)
            #komplexe Variante: schnell erzeugte Rechtecke:
            breitefaktor = 1/4
            """
            dx = (np.max(verschiebung)-np.min(verschiebung)+2)/1000*2*breitefaktor
            nverts = len(verschiebung)*(1+3+1)
            verts = np.zeros((nverts, 2))
            codes = np.ones(nverts, int) * path.Path.LINETO
            codes[0::5] = path.Path.MOVETO
            codes[4::5] = path.Path.CLOSEPOLY
            verts[0::5, 0] = verschiebung-dx
            #verts[0::5, 1] = bottom muss nicht zugewiesen werden: bereits 0
            verts[1::5, 0] = verschiebung-dx
            verts[1::5, 1] = hoehe
            verts[2::5, 0] = verschiebung+dx
            verts[2::5, 1] = hoehe
            verts[3::5, 0] = verschiebung+dx
            #verts[3::5, 1] = bottom
            barpath = path.Path(verts, codes)
            patch = patches.PathPatch(barpath, facecolor='k', edgecolor='k', alpha=0.5, lw = 1)
            ax.add_patch(patch)
            """
            ax.plot([verschiebung[iWerte],verschiebung[iWerte]],[0,hoehe[iWerte]],'k-',lw=2)
            
         
        plt.plot([np.max(verschiebung)+xrand, min(np.min(verschiebung)-10,0)],[0,0],'k-',lw=0.8)
        
        
        #ax.set_ylabel("Intensität")
        ax.set_xlabel(r"chemische Verschiebung $\delta$ [ppm]")
        ax.set_xlim([np.max(verschiebung)+xrand, min(np.min(verschiebung)-10,0)])
        
        #ax.set_xlim([5,-1])
        
        #ax.set_ylim([-,np.max(hoehe)*1.1])
        ax.set_yticks([])
        print(ax.get_xticklabels()[0])
        #ax.set_xticklabels(np.array(ax.get_xticklabels(),dtype=float)*-1)
        ax.spines['top'].set_visible(False)
        ax.spines['right'].set_visible(False)
        ax.spines['left'].set_visible(False)
        ax.xaxis.set_major_locator(MultipleLocator(50))
        if np.max(verschiebung)+xrand < 15:
            ax.xaxis.set_major_locator(MultipleLocator(0.5))
            # For the minor ticks, use no labels; default NullFormatter.
            ax.xaxis.set_minor_locator(MultipleLocator(0.1))
        elif np.max(verschiebung)+xrand < 100:
            ax.xaxis.set_major_locator(MultipleLocator(10))
            ax.xaxis.set_minor_locator(MultipleLocator(1))
        elif np.max(verschiebung)+xrand < 200:
            ax.xaxis.set_major_locator(MultipleLocator(20))
            ax.xaxis.set_minor_locator(MultipleLocator(10))
        else:
            ax.xaxis.set_major_locator(MultipleLocator(50))
            ax.xaxis.set_minor_locator(MultipleLocator(10))
        ax.xaxis.set_major_formatter(FormatStrFormatter('%.1f'))
        
        
        
        
        
        
        #ax.set_xlim([12,-2])
        #ax.set_xticks(np.arange(12,-2,1))
        
        
        name = datei.split('.')[0]
        plt.title(name)
        plt.savefig(verzeichnis+"/CNMR_{}.png".format(name))
"""
datei = dateien[1]
bearbeiten(datei)       
"""
print(dateien)
for datei in dateien:  
    print(datei)
    bearbeiten(datei, verzeichnis)

plt.show()


       
        
