#!/usr/bin/python3
# -*- coding: utf-8 -*-
"""
Das Programm liest eine CSV-Datei (oder auch txt-Datei) ein
entfernt die Kommas und macht aus jedem Eintrag zwischen Kommas eine eigene zelle

Zuunterst den Namen der Dateo (zuunterst!) abändern in den Namen der Datei, die bearbeitet werden soll.

Dieses Python-Programm und die zu bearbeitende Datei müssen sich im gleichen
Ordner befinden (z.B. auf dem Desktop).

Es kann ein Trigger verwendet werden, so dass das Zerlegen der Zeilen erst beginnt,
wenn dieser Trigger vorbei ist (im vorliegenden Beispiel "M/Z".
Diese Möglichkeit wird hier aber nicht verwendet.

@author: Urs Leisinger
"""

#Importieren des Moduls, das nötig ist, um csv-Dateien zu lesen und zu schreiben
import csv

import matplotlib.pyplot as plt
from matplotlib.path import Path
from matplotlib.patches import PathPatch
import matplotlib.patches as mpatches
import numpy as np
import re
from matplotlib.ticker import (MultipleLocator, FormatStrFormatter,
                               AutoMinorLocator)
from matplotlib.colors import ListedColormap, LinearSegmentedColormap
import glob
dateien = glob.glob('*.jdx')

#dateien = ['butan2ol_78-92-2-IR.jdx','ethansaeuremethylester_79-20-9-IR.jdx']
#dateien = ['hydroxyaceton_20240128_20h08_05.jdx']
# dateien = ["IR_fluorescein_20241208_18h03_10.jdx"]

print(dateien)
GradientAufXachseEnden=True

separate_abbildungen = True

###########################
# farbige Peaks
# bei jedem Datenpaar ZUERST DIE KLEINERE ZAHL!!!!!!!
wellenzahllims_list = [[[500,1400]],
                       [[3020,3100],[2936,3020]],
                       []
                       ]

wellenzahllims_list = [[[3020,3100],[2936,3020],[1354,1500], [1186,1354], [850,950], [650,850]],
                  [],
                  []
                  ]
wellenzahllims_list = [[[3425,3500],[3031,3425],[2786,3031],[1614,1684], [1519,1614], [1205,1355], [1105,1170],[851,921]],
                  [],
                  []]
wellenzahllims_list = [[[3050,3700], [2750,3050]],
                  [[1700,1800]],
                  []]
wellenzahllims_list = [[[2950,3050],[2850,2950],[2200,2250],[1600,1800],[500,1500]],
                  [[1700,1800]],
                  []]

wellenzahllims_list = [[[2500,3550],[1636,1877],[1514,1638],[454,1514]],
                  [[1700,1800]],
                  []]

wellenzahllims_list = [[],[],[],[],[],[],[],[],[],[],[],[],[]]


oberer_rand = 99

###########################
# Beschriftung mit Nummern
#wellenzahlen_beschriften = [3000,2900, 2230, 1702, 1100]
wellenzahlen_beschriften = []




## eigene colormaps
N = 256

alphakanal = np.ones(N)
#rot
rotkanal = np.linspace(0.9, 1, N) 
gruenkanal = np.ones(N)*0.5 
blaukanal = np.ones(N)*0.5
cmp_hellrot = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_hellrot #FF8080
rotkanal = np.linspace(0.8, 0.9, N) 
gruenkanal = np.ones(N)*0 
blaukanal = np.ones(N)*0 
cmp_dunkelrot = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_dunkelrot #E60000

#blau
rotkanal = np.ones(N)*0.3 
gruenkanal = np.ones(N)*0.5
blaukanal = np.linspace(0.8, 1, N) 
cmp_hellblau = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_hellblau #4C80CC bis #4C80FF
rotkanal = np.ones(N)*0
gruenkanal = np.ones(N)*0
blaukanal = np.linspace(0.6, 0.8, N) 
cmp_dunkelblau = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_dunkelblau #000099 bis #0000CC

#cyan
rotkanal = np.ones(N)*0.3 
gruenkanal = np.ones(N)*0.8
blaukanal = np.linspace(0.8, 1, N) 
cmp_cyan = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_cyan #4CCCFF
rotkanal = np.ones(N)*0
gruenkanal = np.ones(N)*0.4
blaukanal = np.linspace(0.4, 0.6, N) 
cmp_dunkelcyan = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_dunkelcyan #006699


#gelb
rotkanal = np.linspace(0.8, 1, N)
gruenkanal = np.linspace(0.8, 1, N)
blaukanal = np.ones(N)*0
cmp_zitronengelb = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_zitronengelb #FFFF00
rotkanal = np.linspace(0.8, 1, N)
gruenkanal = np.linspace(0.6, 0.8, N)
blaukanal = np.ones(N)*0
cmp_sonnengelb = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_sonnengelb #FFCC00

#braun
rotkanal = np.linspace(120/256, 153/256, N)
gruenkanal = np.linspace(56/256, 76/256, N)
blaukanal = np.ones(N)*0
cmp_braun = ListedColormap(np.array([rotkanal, gruenkanal, blaukanal,np.ones(N)]).T)
#cmp_braun #99C400


def is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        return False


def gradient_between(x,y, ax, xlimits,ylimits, colormap = plt.cm.Reds, oberer_rand = 100):
    
    ylimitscolorize = [np.min(y),oberer_rand]

    x = np.r_[np.min(x),x,np.max(x)]
    y = np.r_[oberer_rand,y,oberer_rand]

    
    #damit der Umriss nicht gezeichnet wird: edgecolor='none'
    path = Path(np.array([x,y]).transpose())
    patch = PathPatch(path, facecolor='none', edgecolor='none')
    plt.gca().add_patch(patch)
    
    ycolor = np.linspace(0,1,100)

    #eigentlich wird hier nur eine eindimensionale Linie gezeichnet mit so vielen Punjkten wie ycolor Elemente enthält
    #und jeder Punkt wird dann entsprechend seinem ycolor-Wert eingefärbt
    #durch extent wird dann aber diese Linie auf die Breite des Plots auseinandergezogen, so dass die ganze Fläche ein Gradient wird
    #dann wird daraus der patch ausgeschnitten
    im = ax.imshow(ycolor.reshape(ycolor.size,1),  #Array, in dem jeder Wert von X in einer eigenen Liste steckt. 
                cmap=colormap,
                interpolation="bicubic",
                origin='upper',#bestimmt, wo das dunkle Ende ist
                extent=[i for i in list(xlimits)+ylimitscolorize],#die beiden Listen effizient zu einer machen
                aspect="auto",
                vmin = -0.2,#wert mit der Farbe am einen Rand der cmap. Alle tieferen Werte werden gleich eingefärbt
                vmax = 1,#wert mit der Farbe am anderen  Rand der cmap. Alle höheren Werte werden gleich eingefärbt
                clip_path=patch, #das Innere dieses pfades wird gefärbt, was ausserhalb ist, nicht
                clip_on=True,
                zorder = 10
                )
    return im
    #ylimitscolorize = [np.min(y),100]
    ylimitscolorize = [0,100]
    
    x = np.r_[np.min(x),x,np.max(x)]
    y = np.r_[100,y,100]

    
def gradient_between_2(x,y, ax, xlimits,ylimits, colormap = plt.cm.Reds):
    #Farbe als Funktion von x und y (xcolor und ycolor)
    #zuerst clip_on = False, dann  clip_on = True 
    
    #damit der Umriss nicht gezeichnet wird: edgecolor='none'
    path = Path(np.array([x,y]).transpose())
    patch = PathPatch(path, facecolor='none', edgecolor='none')
    plt.gca().add_patch(patch)
    

    ycolor = np.linspace(-1,1,100)
    xcolor = np.linspace(-1,1,100)
    yycolor,xxcolor = np.meshgrid(xcolor,ycolor)
    rrcolor = (xxcolor**2+yycolor**2)**0.5
    zzcolor = np.exp(-(rrcolor)**2)
    
    #von unten her, anders herum als die Achse beschriftet ist: 100 ist der obere Rand, der erste Wert der untere Rand, bei dem die Farbe hell sein soll (und dann dunkel und wieder hell wird).
    ylimitscolorize = [90,100]
    
    #eigentlich wird hier nur eine eindimensionale Linie gezeichnet mit so vielen Punkten wie ycolor Elemente enthält
    #und jeder Punkt wird dann entsprechend seinem ycolor-Wert eingefärbt
    #durch extent wird dann aber diese Linie auf die Breite des Plots auseinandergezogen, so dass die ganze Fläche ein Gradient wird
    #dann wird daraus der patch ausgeschnitten
    
    #im prinzip könnte man natürlich auch ein beliebiges Bild verwenden.
    im = ax.imshow(zzcolor,  #Array, in dem jeder Wert von X in einer eigenen Liste steckt. 
                cmap=colormap,
                interpolation="bicubic",
                origin='upper',#bestimmt, wo das dunkle Ende ist
                extent=[i for i in list(xlimits)+ylimitscolorize],#die beiden Listen effizient zu einer machen
                aspect="auto",
                vmin = -0.2,#wert mit der Farbe am einen Rand der cmap. Alle tieferen Werte werden gleich eingefärbt
                vmax = 1,#wert mit der Farbe am anderen  Rand der cmap. Alle höheren Werte werden gleich eingefärbt
                clip_path=patch, #das Innere dieses pfades wird gefärbt, was ausserhalb ist, nicht
                clip_on=True,
                zorder = 10
                )
    return im 
    

gs_kw = dict(wspace=0.3, left = 0.1, right =0.9, bottom = 0.2, top = 0.9)
fig,ax = plt.subplots(nrows = 1, ncols=1, sharey = False, figsize = (6,3), constrained_layout=True)

def beschriftung(wellenzahl,text):
    ax.text(wellenzahl,100,text, horizontalalignment="center", verticalalignment = "center", size=8)



def bearbeiten(datei, linestyle, fuellfarbe, wellenzahllims, colormaps):
    global xlimits

    if separate_abbildungen == True:
        ax.cla()
    ax1 = ax
    """
    
    gs_kw = dict(wspace=0.3, hspace = 0.3, left = 0.12, right =0.9, bottom = 0.07, top = 0.95)
    fig,ax = plt.subplots(nrows = 2, ncols=1, figsize = (9,9), constrained_layout=True)  
    ax1 = ax[1]
    ax0 = ax[0]
    """
    
    
    """
    Solange werte=False ist man im Kopfbereich der Datei
    der noch keine Daten enthält (damit hier nicht auch alle Zeilen
    verdoppelt und Nullen hinzugefügt werden
    """
    #werte=False;
    werte=True;
    """
    Nun wird die neu zu speichernde Datei vorbereitet.
    Sie soll gleich heissen, wie die alte, aber mit dem Zusatz _neu
    Zu diesem Zweck wird der alte Dateiname zuerst beim Punkt in zwei Teile zerlegt (mit split)
    der erste Teil (also der Name ohne das Kürzel ".csv" wird mit _neu.csv
    zusammengebaut. Das ist dann der neue Dateiname)
    """
    #ursprüngliche Datei einlesen
    with open(datei,'rb') as dateiLesen:
        #um das bytes-Objekt in str-Objekt umzuwandeln
        dateiEingelesen=dateiLesen.read().decode("utf-8")
        
        #hier wird die eingelesene Datei in einzelne Zeilen zerlegt (Zeilenwechsel: \n)
        #Wenn die eingelesene Datei ein bytes-Objekt ist, muss auch die zu splittende Stelle
        #als byte-objekt (also mit b vor den Anführungszeichen) übergeben werden.
        #dateiEingelesen=dateiEingelesen.split(b'\n')
        dateiEingelesenListe=dateiEingelesen.split('\n')
        xWerte=[]
        yWerte=[]
        yfactor = 1
        xfactor = 1
        dx = 1
        wertebereich=False
        #herausfinden, ob die Werte nach zunehmd oder abnehmend geordnet sind:
        faktor = None
        wert = None
        i = 0
        while faktor == None:
            zeile = dateiEingelesenListe[i]
            if zeile !='' and zeile.find(' ')>-1:
                werte=zeile.split(' ')
                if is_number(werte[0]):
                    if wert == None:
                        wert = werte[0]
                    else:
                        if werte[0] > wert:
                            faktor = 1
                        else:
                            faktor = -1
                        print("wert1, wert2, faktor",wert,werte[0],faktor)
            i += 1
            

        
        for zeile in dateiEingelesenListe:
            if zeile.find('XFACTOR')>-1:
                xfactor = float(zeile.split('=')[1])
            if zeile.find('YFACTOR')>-1:
                yfactor = float(zeile.split('=')[1])
            if zeile.find('##DELTAX')>-1:
                dx = float(zeile.split('=')[1])
            if zeile !='' and zeile.find(' ')>-1:
                werte=zeile.split(' ')
                if wertebereich == True and  re.search(werte[0], '\d')!='none':
                    xW = float(werte[0])
                    xWerte.append(float(werte[0]))
                    yWerte.append(float(werte[1]))
                    if len(werte)>2:
                        for i in range(len(werte)-2):
                            xWerte.append(xW + (i+1)*dx*faktor)
                            yWerte.append(float(werte[i+2]))
            if zeile.find("##XYDATA")> -1:
                wertebereich = True
                
        wellenzahl = np.array(xWerte)/xfactor

        if dateiEingelesen.find('##YUNITS=TRANSMITTANCE')>-1:
            transmission = 100 * np.array(yWerte)*yfactor
        elif dateiEingelesen.find('##YUNITS=ABSORBANCE')>-1:
            transmission = 100 * 10**(- np.array(yWerte)*yfactor)
        

            
        #minima suchen
        threshold=0.85
        peaks=[]
        peakpositionen=[]
        for i in range(1, len(transmission)-1):
            if transmission[i] < threshold and transmission[i-1] >= transmission[i] and transmission[i] <= transmission[i+1]:
                peaks.append(transmission[i])
                peakpositionen.append(wellenzahl[i])
        #maxima suchen
##        for i in range(1, len(transmission)-1):
##            if transmission[i] > threshold and transmission[i-1] <= transmission[i] and transmission[i] >= transmission[i+1]:
##                peaks.append(transmission[i])
##                peakpositionen.append(wellenlaenge[i])        
        print("Peaks mit Werten unter ",threshold,":")
        print("Anzahl Peaks: ",len(peaks))
        print("Wellenlaengen:",peakpositionen)
        print("Extkinktionen:",peaks)
                

        ax1.plot(wellenzahl,transmission,linestyle, lw=1, zorder=11)
        ax1.xaxis.set_major_locator(MultipleLocator(500))
        ax1.xaxis.set_minor_locator(MultipleLocator(100))
        xlimits = ax1.get_xlim()
        ylimits = ax1.get_ylim()
        
        for i in range(int(xlimits[1]-xlimits[0])//100 +1):
            x0 = round(xlimits[0]/100)*100
            ax1.plot([x0+i*100,x0+i*100], ylimits, ls = '-',lw=0.2, color ="gray")
        ax1.grid()
        ax1.set_xlabel(r"Wellenzahl $\bar{\nu} \ [cm^{-1}] $")
        ax1.set_ylabel("Transmission [%]")
        name = datei.split('.')[0]
        plt.title(name +"\n")
        
        """
        hex(int(0.84*255))
        
        plt.cm.Reds, rot #FF5555  OH =CH etc
        plt.cm.Greens #6BBF70       CH Streck asymm
        plt.cm.YlOrBr, #FFBC47      CH Streck symm
        plt.cm.gist_heat #41301E #643500    Mehrfachbindungen streck
        plt.cm.Blues #AAAAFF        Scherschwingungen
        plt.cm.Wistia (gelb): #FFE014 Wippschwingung rudern
        plt.cm.summer, (sattgrün) #3D9E66 Schaukelschwingung
        
        plt.cm.Oranges #FF7C00
        plt.cm.Purples  #BCBCDB   Bereich unter 1500, Beugeschwingungen C-H
        plt.cm.spring  (pink) #FF3AC4    Funktionelle-Gruppen spezifisch
        plt.cm.cool : #609EFF             Funktionelle-Gruppen spezifisch
        plt.cm.autumn: (satt rot) #FF2B00     Funktionelle-Gruppen spezifisch
        plt.cm.winter: (satt blau) #004FD6
        plt.cm.PiYG (dunkleres Pink)  #7C2556

        https://matplotlib.org/stable/tutorials/colors/colormaps.html

        #rot
        #cmp_hellrot #FF8080
        #cmp_dunkelrot #E60000
        
        #blau
        #cmp_hellblau #4C80CC bis #4C80FF
        #cmp_dunkelblau #000099 bis #0000CC
        
        #cyan
        #cmp_cyan #4CCCFF
        #cmp_dunkelcyan #006699
        
        
        #gelb
        #cmp_zitronengelb #FFFF00
        #cmp_sonnengelb #FFCC00
        
        #braun
        #cmp_braun #99C400


        """
        
        
        if fuellfarbe != None:
            plt.fill_between(wellenzahl,transmission,np.array(transmission)*0+100,color = fuellfarbe)

        


        
        i_count = 0
        for wzmin, wzmax in wellenzahllims:
            wz = wellenzahl[wellenzahl >= wzmin]
            tr = transmission[wellenzahl >= wzmin]
            tr = tr[wz <= wzmax] #vorsicht: Reihenfolge entscheidend!
            wz = wz[wz <= wzmax]
            print("tr=",tr)
            print("wz=",wz)
            
            #Gradient entlang X-Achse
            if len(wz)>0:
                if GradientAufXachseEnden:
                    tr=np.concatenate(([100],tr))
                    wz=np.concatenate(([wz[0]],wz))
                    tr=np.concatenate((tr,[100]))
                    wz=np.concatenate((wz,[wz[-1]]))
    
                gradient_between(wz,tr, ax, xlimits,ylimits, oberer_rand = oberer_rand, colormap = colormaps[i_count])
            i_count += 1
        
        ax1.set_xlim([max(xlimits),min(xlimits)]) # sonst dreht sich die Achse bei jedem zweiten Mal um
        ax1.set_ylim([ylimits[0],ylimits[1]])

        plt.savefig("{}.png".format(name))

# https://matplotlib.org/stable/gallery/color/colormap_reference.html
#help(plt.cm)
cmaps = plt.colormaps()
for e in ['Accent_r', 'Pastel1', 'Pastel2', 'Paired', 'Accent',
            'Dark2', 'Set1', 'Set2', 'Set3',
            'tab10', 'tab20', 'tab20b', 'tab20c']:
    cmaps.remove(e)
cmaps = cmaps[::2] #reverse entfernen

colormaps_list = [[plt.cm.Reds,plt.cm.Greens, plt.cm.Blues,plt.cm.Oranges, plt.cm.Purples, plt.cm.cool, plt.cm.Wistia , plt.cm.summer, plt.cm.spring, plt.cm.autumn, plt.cm.winter, plt.cm.gist_heat],
                  cmaps,cmaps,cmaps,cmaps,cmaps]
colormaps_list = [[cmp_hellblau,cmp_braun, cmp_dunkelblau, cmp_cyan,cmp_dunkelcyan, cmp_zitronengelb,cmp_sonnengelb,plt.cm.Greens, plt.cm.Blues,plt.cm.Oranges, plt.cm.Purples, plt.cm.cool, plt.cm.Wistia , plt.cm.summer, plt.cm.spring, plt.cm.autumn, plt.cm.winter, plt.cm.gist_heat],
             cmaps[24:],cmaps,cmaps,cmaps,cmaps,cmaps]
        






for i in range(len(wellenzahlen_beschriften)):
    w = wellenzahlen_beschriften[i]
    beschriftung(w,"({})".format(i+1))
ax.set_ylim([-4,110])


linestyles = ["k-", "b:","r--"]
linestyles = ["k-", "k-","k-","k-","k-","k-","k-","k-","k-","k-","k-","k-","k-"]
fuellfarben = [None, "#eeeeee", None, None, None ]
fuellfarben = [None, None, None, None, None, None, None , None, None , None, None  ]

for (d, linestyle, fuellfarbe, wellenzahllims, colormaps) in zip(dateien, linestyles, fuellfarben, wellenzahllims_list, colormaps_list):
    bearbeiten(d, linestyle, fuellfarbe, wellenzahllims, colormaps)
print(cmaps)
plt.show()    
        
