# -*- coding: utf-8 -*-
"""
Created on Wed Aug 25 21:41:51 2021

@author: Urs
"""
from PIL import Image
import numpy as np
import matplotlib.pyplot as plt
import datetime
import glob

xlinksrechts_aus_name = False
if xlinksrechts_aus_name == False:
    xlinks = 4000
    xrechts = 00

verwendeter_kanal = "b" #r, g, b


# um wie viel grösser als der minimale Farbwert darf der WErt eines Pixels sein, damit es genommen wird?
faktor_suchwert = 1.5 # 1: nur das Pixel mit dem tiefsten Farbwert wird genommen

# Maximaler und minimaler Wert (y-Achse der Abbildung)
yunten = 0
yoben = 1

umrechnung_abs_transmittance = False #abs, absorbance (Umrechnung in Transmittance), trans (keine Umrechnung)




dateien = glob.glob("*.png")
#dateien = ["LDPE_4000_0500.png"]

von_oben = True

#mittel über n*n Pixel, falls originaldaten keine gute Kurve liefern.
n = 1 # 1 für unveränderte Daten, keine Mittelbinldung zwischen Pixeln


"""
skalentyp: 
    1: linear
    2: logarithmisch
    3: speziell (sdbs.db.aist.go.jp): von 4000 bis 2000 halb so gross wie von 2000 bis 500 oder 400
"""



skalentyp = 3

###### für Skalentyp 3:
    
"""
if xrechts == 400:
        delta_x_verzerrt = -1200
elif rechts == 500:
        delta_x_verzerrt = -1000
"""

delta_x_verzerrt = -2000 + 2*xrechts
##### 

def timestamp():
    x = datetime.datetime.now()
    return x.strftime("%Y%m%d_%Hh%M_%S")

def colorfunc(h,s,v,n):
    k = (n + h/60)%6 
    return int(255*(v - v * s * max(0,min(k,4-k,1))))

def hsv_to_rgb(h=0,s=1,v=1):
    #hue (0..360), value (0..1), saturation (0..1)
    return (colorfunc(h,s,v,5),colorfunc(h,s,v,3),colorfunc(h,s,v,1))


def bild_einlesen(d, n):
    #das Bild wird geöffnet
    global xrechts, xlinks
    name = "RAMAN_"+d.split(".")[0]
    if xlinksrechts_aus_name:
        namenteile = d.split(".")[0].split("_")
        print (namenteile)
        name = "IR_"+namenteile[0]
        xlinks = int(namenteile[1])
        xrechts = int(namenteile[2])
        
    
    n1 = n-1 
    img = Image.open(d) 
    print("Datei: ",d)
    pixels = np.array(img)
    print("shape", pixels.shape,len(pixels.shape))
    if len(pixels.shape)==2:
        img = img.convert('RGB')
        pixels = np.array(img)
    nRows = pixels[:,:,0].shape[0]
    nCols = pixels[:,:,0].shape[1] 
    
    print("Breite {}, Höhe: {}".format(nCols,nRows))
    
    
    # man kann nun mit irgend einem Kanal weiterarbeiten
    if verwendeter_kanal == "r":
        #rotkanal
        kanal = pixels[:,:,0]
    elif verwendeter_kanal == "g":
        #gruenkanal
        kanal = pixels[:,:,1] 
    elif verwendeter_kanal == "b":
        #blaukanal
        kanal = pixels[:,:,2]
    print("shapes", pixels.shape, kanal.shape)
    
    kanal_m = np.zeros((nRows-n1,nCols-n1))
    for i in range(nRows-n1):
        for j in range(nCols-n1):
            kanal_m[i,j] = int(np.sum(kanal[i:i+n,j:j+n])/n/n)
    
    kanal_m /= np.max(kanal_m)
    
    nRows_m, nCols_m = kanal_m.shape
    pixels_m = np.zeros((nRows_m, nCols_m, 4))
    for i in range(nRows_m):
        for j in range(nCols_m):
            pixels_m[i,j] = [kanal_m[i,j], kanal_m[i,j], kanal_m[i,j], 255]
    
    
    fig,ax = plt.subplots(2,1, num=name+"_Spektrum")
    imgplot = ax[0].imshow(kanal_m)
    imgplot1 = ax[0].imshow(np.array(pixels_m))
    fig.suptitle(name, fontsize=10)

    deltax = (xrechts-xlinks)/nCols*(nCols-n1)
    
    
    if skalentyp == 1:
        x = np.linspace(xlinks,xlinks + deltax,nCols-n1)  
    elif skalentyp == 2: 
        xmin_log = np.log(xlinks) 
        xmax_log = np.log(xlinks + deltax)
        x_log = np.linspace(xmin_log, xmax_log, nCols-n1)
        x = np.exp(x_log)
        ax[1].set_xscale('log')
    elif skalentyp == 3:
        x = np.linspace(xlinks,delta_x_verzerrt,nCols-n1) 
        for i in range(len(x)):
            if x[i]<2000:
                x[i] = 0.5*x[i] + 1000
    

    deltay = (yunten-yoben)/nRows*(nRows-n1)
    yrange = np.linspace(yoben, yoben+deltay, nRows-n1)
    
    y=[]
    for i in range(nCols-n1):
        # extremwert ist der Wert im gewählten Kanal mit dem kleinsten Farbwert. 
        # suchwert: bei einer schwarzen Kurven sollen z.B. auch graue Pixel gefunden werden, also suchwert etwas grösser als Extremwert.
        
        extremwert =  np.amin(kanal_m[:,i])
        suchwert = extremwert * faktor_suchwert   #auch etwas weniger dunkle Pixel werden genommen
        
        if von_oben == True:
            index = np.where(kanal_m[:,i] <= suchwert)[0][0]
        else: 
            index = np.where(kanal_m[:,i] <= suchwert)[0][-1]
        y.append(yrange[index])
    ax[1].set_xlim([xlinks,xrechts])
    ax[1].set_ylim([yunten,yoben])
    
    y = np.array(y)
    
    if umrechnung_abs_transmittance: #umrechnung von abs zu transmittance
        
        y = 10**-y
        ax[1].set_ylim([yunten,yoben])
    
    ax[1].plot(x,y)
    
    #--------------------------------------------------
    #####ausgabe
    
    # CSV
    text = "Wavenumber;Intensity\n"
    f = 100 # von 1 auf 100% umrechnen für excel
    for i in range(len(x)):
        text += str(x[i]) + ";" + str(y[i]*f) + "\n"
    with open(name+"_{}.csv".format(timestamp()), "w", encoding='utf8') as f:
        f.write(text)    
    
    # .jdx Datei für IR-Spektrum
    text = """##XUNITS=1/CM
##YUNITS=TRANSMITTANCE
##XFACTOR=1.0
##YFACTOR=1
##FIRSTX={}
##LASTX=4000
##FIRSTY=0.7652
##MAXX={}
##MINX={}
##MAXY={}
##MINY=0
##NPOINTS
##XYDATA=(X++(Y..Y))""".format(xrechts, xlinks, xrechts,yoben/100 )
    x_rev = x[::-1]
    y_rev = y[::-1]
    for i in range(len(x_rev)):
        text += str(x_rev[i]) + " " + str(y_rev[i]) + "\n"
    #print(text)
    with open(name+"_{}.jdx".format(timestamp()), "w", encoding='utf8') as f:
        f.write(text)
    
    
for datei in dateien:    
 
   
    bild_einlesen(datei, n)

    plt.show()