#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Mar 31 17:07:30 2021

@author: ursleisinger
"""

import pandas as pd
import glob
import numpy as np
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
from scipy.ndimage import gaussian_filter1d

print("Current backend:", matplotlib.get_backend())

# Abbildungen unterdrücken
plt.switch_backend('Agg')

#abbildungen darstellen
#plt.switch_backend('Qt5Agg')  # Or 'TkAgg', QtAgg depending on your setup

#zusatzlinien: wenn es leere Linien gibt im gefärbten Transmissions-Spektrum 
zusatzlinien = 10

# glätten
sigma = 4 # Standard deviation for Gaussian kernel (vermutlich abstand in x-Richtung für die Berücksichtigung von Werten)
#wenn deltaWellenlänge zwischen den messpunkten immer gleich ist 
delta_wavelength_konstant = False

dateiliste=glob.glob("*.xlsx")
print(dateiliste)

def wavelength_to_rgb(wavelength, gamma=0.8):
    '''This converts a given wavelength of light to an 
    approximate RGB color value. The wavelength must be given
    in nanometers in the range from 380 nm through 750 nm
    (789 THz through 400 THz).

    Based on code by Dan Bruton
    http://www.physics.sfasu.edu/astro/color/spectra.html
    '''

    wavelength = float(wavelength)
   
    
    
    if wavelength >= 380 and wavelength <= 440:
        startatt = 1
        attenuation = startatt - startatt * (440-wavelength) / (440 - 380)
        #Korrektur, weil die Farben am kurzwelligen Ende zu violett sind:
        #wavelength = 440-(440-wavelength)/3
        #startatt = 1
        #attenuation = startatt - startatt * (440-wavelength) / (440 - 420)
        R = ((-(wavelength - 440) / (440 - 380)) * attenuation) ** gamma
        G = 0.0
        B = (1.0 * attenuation) ** gamma
    elif wavelength >= 440 and wavelength <= 490:
        R = 0.0
        G = ((wavelength - 440) / (490 - 440)) ** gamma
        B = 1.0
    elif wavelength >= 490 and wavelength <= 510:
        R = 0.0
        G = 1.0
        B = (-(wavelength - 510) / (510 - 490)) ** gamma
    elif wavelength >= 510 and wavelength <= 580:
        R = ((wavelength - 510) / (580 - 510)) ** gamma
        G = 1.0
        B = 0.0
    elif wavelength >= 580 and wavelength <= 645:
        R = 1.0
        G = (-(wavelength - 645) / (645 - 580)) ** gamma
        B = 0.0
    elif wavelength >= 645 and wavelength <= 750:
        attenuation = 0.3 + 0.7 * (750 - wavelength) / (750 - 645)
        R = (1.0 * attenuation) ** gamma
        G = 0.0
        B = 0.0
    # selber, um keinen scharfen Rand zu haben: 
    elif wavelength >= 750 and wavelength <= 760:
        attenuation = 0.3 - 0.3 * (wavelength-750) / 10
        R = (1.0 * attenuation) ** gamma
        G = 0.0
        B = 0.0
    else:
        R = 0.0
        G = 0.0
        B = 0.0
    #R *= 255
    #G *= 255
    #B *= 255
    #return (int(R), int(G), int(B))
    return (R,G,B)


def spektrumDarstellen(datei, typ = 1):
    """

    Parameters
    ----------
    datei : TYPE
        DESCRIPTION.
    typ : TYPE, optional
        typ = 1: Extinktionsspektrum, Spektralfarben nicht absorptionsabhängig
        typ = 2: Transmissionsspektrum
        typ = 3: Transmissionsspektrum, mit Spektralfarben 

    Returns
    -------
    None.

    """
    df = pd.read_excel(datei, sheet_name = 0, header=None)
    print("---Datei", datei)
    #n_messungen = len(df.columns)//2 

    for i_m in range(1):
        titel = datei.split(".")[0]
        titel = "leer"
        print(titel)
    
        messung = np.array(df.iloc[14:,1:3], dtype = float)
        #print(messung)  
        wavelength = messung[:,0]
        absorbance = messung[:,1] 
        absorbance = np.random.random(len(absorbance))/100   ################# Absorbance überschreiben
        #absorbance normieren für Transmittance, so dass das minimum immer bei 1/10 liegt
        absorbance_norm = absorbance
        
        
        
        smoothed_absorbance = gaussian_filter1d(absorbance, sigma=sigma)  
        smoothed_absorbance_norm = smoothed_absorbance
        transmittance = 10**-absorbance_norm
        transmittance = np.where(transmittance<=1,transmittance,1)
        smoothed_transmittance = 10**-smoothed_absorbance_norm 
        smoothed_transmittance= np.where(smoothed_transmittance<=1,smoothed_transmittance,1)
        #absorbance = -np.log10(transmittance)
        
        if typ == 1:
            # Create a figure with constrained layout
            fig = plt.figure(constrained_layout=True, figsize=(8, 6))
            
            # Define a GridSpec with 2 rows and 1 column
            gs = gridspec.GridSpec(3, 1, height_ratios=[4, 1, 1], figure=fig)  # Heights: 2:1
            
            
            
            # Create the first (larger) axis
            ax1 = fig.add_subplot(gs[0])
            ax1.set_title(titel)
            ax1.set_xlabel("Wellenlänge [nm]")
            ax1.set_ylabel("Extinktion")
            ax1.plot(wavelength, smoothed_absorbance_norm , "k-")
            
            ax2 = fig.add_subplot(gs[1], sharex=ax1)
            ax2.set_yticks([])
            ax3 = fig.add_subplot(gs[2], sharex=ax1)
            ax3.set_yticks([])
            

            # Step 3: Generate the colorized region
            resolution = len(wavelength)  # Number of pixels along the x-axis           
            x_range = np.linspace(np.min(wavelength), np.max(wavelength), resolution)
        
            brightness = smoothed_transmittance[::-1] # pixel haben umgekehrte Reihenfolge
            
            # Step 4: Create an image to represent the pixel region
            image_height = 100  # Pixels high for visualizing brightness
            pixels = np.zeros((image_height, resolution, 3))  # RGB image
            pixels_2 = np.zeros((image_height, resolution, 3))  # RGB image
            for i, x_val in enumerate(x_range):
                r, g, b = wavelength_to_rgb(x_val)
                pixels[:, i, :] = (r,g,b)
                helligkeit = brightness[i]
                rgb_2 = (r*helligkeit,g*helligkeit,b*helligkeit)
                pixels_2[:, i, :] = rgb_2  # Set the same color for all rows (constant brightness)
            extent = [np.min(wavelength), np.max(wavelength), -1, -0.5]  # Specify where to place the image
            ax3.imshow(pixels, aspect='auto', extent=extent, origin='lower')
            if delta_wavelength_konstant == True:
                ax2.imshow(pixels_2, aspect='auto', extent=extent, origin='lower')
            else: 
                # wenn die Abstände zwischen den Messpunkten unterschiedlich gross sind, geht die obige Variante mit Pixeln nicht. 
                # Daher hier die Alternative 
                # anstelle von ax2.imshow(pixels_2, aspect='auto', extent=extent, origin='lower')
                
                for i in range(len(wavelength)):
                    if i < len(wavelength)-1:
                        for k in range(zusatzlinien): #da zu wenige messwerte:
                            hoehe = 1 #
                            xk = wavelength[i] + (wavelength[i+1]-wavelength[i])/zusatzlinien * k
                            r, g, b = wavelength_to_rgb(xk)
                            helligkeit = smoothed_transmittance[i] + (smoothed_transmittance[i+1]-smoothed_transmittance[i])/zusatzlinien * k
                            ax2.plot([xk, xk],[0,hoehe],color=(r*helligkeit,g*helligkeit,b*helligkeit), lw=1)
                    else: 
                        hoehe = smoothed_transmittance[i]
                        r, g, b = wavelength_to_rgb(wavelength[i])
                        ax2.plot([wavelength[i],wavelength[i]],[0,hoehe],color=(r,g,b), lw=1)   
            
            
            
            
            
            ax1.set_ylim([-0.1,1.1]) #############
            
            
            dateiname = f"_leer_ext.png"
            ax1.grid(zorder=-10)
            
            
        elif typ > 1:
            # Gaussian smoothing
            
             
            
            fig, ax = plt.subplots(constrained_layout=True)
            ax.set_title(titel)
            ax.set_xlabel("Wellenlänge [nm]")
            ax.set_ylabel("Transmission")
            
            if typ == 3:
                for i in range(len(wavelength)):
                    
                    if i < len(wavelength)-1:
                        for k in range(zusatzlinien): #da zu wenige messwerte:
                            hoehe = smoothed_transmittance[i] + (smoothed_transmittance[i+1]-smoothed_transmittance[i])/zusatzlinien * k
                            xk = wavelength[i] + (wavelength[i+1]-wavelength[i])/zusatzlinien * k
                            r, g, b = wavelength_to_rgb(xk)
                            ax.plot([xk, xk],[0,hoehe],color=(r,g,b), lw=1)
                    else: 
                        hoehe = smoothed_transmittance[i]
                        r, g, b = wavelength_to_rgb(wavelength[i])
                        ax.plot([wavelength[i],wavelength[i]],[0,hoehe],color=(r,g,b), lw=1)                       
                dateiname = f"_leer_transmissionspektrum.png"
            else:
               dateiname = f"_leer_transmission.png"
            ax.plot(wavelength, smoothed_transmittance, "k-")
            plt.grid(zorder=-10)  
            ax.set_ylim([-0.1,1.1]) #############
        plt.savefig(dateiname)
        plt.close()

            
            
 



    

spektrumDarstellen(dateiliste[0], typ = 1)
spektrumDarstellen(dateiliste[0], typ = 2)
spektrumDarstellen(dateiliste[0], typ = 3)
    
plt.show()
plt.switch_backend('Qt5Agg')